function PlotMultiDim(Data,Results)
%This function creates a multidimensional plot for the OSI model
Y=Results.Y;
m=size(Y,1);
p = size(Y{1},2);
clf
hold on
if p<=3
    for j=1:m
        if any(Data.V(:,j))
            Yj=Y{j};
            Vallabelsj=Data.Vallabels{j};
            for i=1:size(Yj,1)
                if p==2
                    Yij1 = Yj(i,1);
                    Yij2 = Yj(i,2);
                    Yij1Text = Yij1;
                    Yij2Text = Yij2;
                    HorizontalAlignment = 'center';
                    VerticalAlignment   = 'bottom';
                    Yij1Stan = Yij1/(Yij1^2+Yij2^2)^.5;
                    Yij2Stan = Yij2/(Yij1^2+Yij2^2)^.5;
                    AngleX = acos(Yij1Stan);
                    AngleY = asin(Yij2Stan);
                    if     Yij1 >= 0 && Yij2 >= 0  % Quadrant x=+ & y=+
                        Angle = AngleY;
                    elseif Yij1 >= 0 && Yij2 < 0   % Quadrant x=+ & y=-
                        Angle = AngleY;
                    elseif Yij1 < 0  && Yij2 >= 0  % Quadrant x=- & y=+
                        Angle = AngleX;
                    elseif Yij1 < 0  && Yij2 < 0   % Quadrant x=- & y=-
                        Angle = -AngleX;
                    end
                    if Angle>=-pi/6 && Angle<pi/6
                        VerticalAlignment   = 'middle';
                        HorizontalAlignment = 'left';
                    elseif Angle>=pi/6 && Angle<pi*2/6
                        VerticalAlignment   = 'baseline';
                        HorizontalAlignment = 'left';
                    elseif Angle>=pi*2/6 && Angle<pi*4/6
                        VerticalAlignment   = 'baseline';
                        HorizontalAlignment = 'center';
                    elseif Angle>=pi*4/6 && Angle<pi*5/6
                        VerticalAlignment   = 'baseline';
                        HorizontalAlignment = 'right';
                    elseif (Angle>=pi*5/6 && Angle<pi) || (Angle>=-pi && Angle<-pi*5/6)
                        VerticalAlignment   = 'middle';
                        HorizontalAlignment = 'right';
                    elseif Angle>=-pi*5/6 && Angle<-pi*4/6
                        VerticalAlignment   = 'cap';
                        HorizontalAlignment = 'right';
                    elseif Angle>=-pi*4/6 && Angle<-pi*2/6
                        VerticalAlignment   = 'cap';
                        HorizontalAlignment = 'center';
                    elseif Angle>=-pi*2/6 && Angle<-pi*1/6
                        VerticalAlignment   = 'cap';
                        HorizontalAlignment = 'lef';
                    end
                    plot([0 Yij1],[0 Yij2],'.-','UserData',[j,i],'ButtonDownFcn','PlotProjections',...
                        'Markersize',10,'LineWidth',0.5,'Color','k')
                    text(Yij1Text,Yij2Text,[Data.Varlabels{j} ': '  Vallabelsj{i}],...
                        'HorizontalAlignment',HorizontalAlignment,'VerticalAlignment',VerticalAlignment,'ButtonDownFcn','PlotProjections')
                elseif p==3
                    HorizontalAlignment = 'center';
                    VerticalAlignment   = 'bottom';
                    plot3([0 Yj(i,1)],[0 Yj(i,2)],[0 Yj(i,3)],'.-','ButtonDownFcn','PlotProjections',...
                        'Markersize',12,'LineWidth',0.5,'Color','k')
                    text(Yj(i,1),Yj(i,2),Yj(i,3),[Data.Varlabels{j} ': '  Vallabelsj{i}],'HorizontalAlignment',HorizontalAlignment,...
                        'VerticalAlignment',VerticalAlignment,'ButtonDownFcn','PlotProjections')
                end
            end
        end
    end
else
    for p1=1:p-1
        for p2=p1+1:p
            if p1~=p2
                subplot(p-1,p-1,(p1-1)*(p-1)+p2-1)
                for j=1:m
                    Y1=Y{j}(:,[p1 p2]);
                    Vallabelsj=Data.Vallabels{j};
                    for i=1:size(Y{j},1)
                        plot([0 Y1(i,1)],[0 Y1(i,2)],'.-','UserData',[j,i],'ButtonDownFcn','PlotProjections',...
                            'Markersize',10,'LineWidth',0.5,'Color','k')
                        hold on
                        text(Y1(i,1),Y1(i,2),[Data.Varlabels{j} ': '  Vallabelsj{i}],'HorizontalAlignment','center', 'VerticalAlignment','bottom','ButtonDownFcn','PlotProjections')
                    end
                end
                xlabel(['Dimension ' num2str(p1)])
                ylabel(['Dimension ' num2str(p2)])
            end
        end
    end
end
if p==2
    xlabel('Dimension 1')
    ylabel('Dimension 2')
elseif p==3
    xlabel('Dimension 1')
    ylabel('Dimension 2')
    zlabel('Dimension 3')
end
axis equal
hold off
v = axis;Min_x=v(1);Max_x=v(2);Min_y=v(3);Max_y=v(4);
a=.1;
axis([(Min_x-a*(Max_x-Min_x)),(Max_x+a*(Max_x-Min_x)),(Min_y-a*(Max_y-Min_y)),(Max_y+a*(Max_y-Min_y))]);
set(gcf,'Units','Normalized')
set(gcf,'Position',[0.02 0.04  .95 .85])